package com.gogirl.interfaces.product.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.product.QueryProduceDetailResp;
import com.gogirl.shared.product.serve.QueryProducePageRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;


@Api(tags = {"款式接口"})
@RestController
@AllArgsConstructor
public class ProduceController {

    private final BaseProduceService baseProduceService;


    @GetMapping("/customer/serve/no_queryProducePage")
    @ApiOperation(value = "款式列表")
    public JsonResult<IPage<BaseProduce>> queryProducePage(QueryProducePageRequest request) {
        IPage<BaseProduce> page = baseProduceService.queryProducePage(request);
        return JsonResult.success(page);
    }


    @GetMapping("/technician/serve/no_queryProducePage")
    @ApiOperation(value = "美甲师款式列表")
    public JsonResult<IPage<BaseProduce>> techQueryProducePage(QueryProducePageRequest request) {
        IPage<BaseProduce> page = baseProduceService.queryProducePage(request);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "查询款式详情", notes = "查询款式详情")
    @AuthIgnore
    @GetMapping("/customer/produce/queryProduceDetail")
    public JsonResult<BaseProduce> queryProduceDetail(Integer id) {
        BaseProduce baseProduce = baseProduceService.getProduceForDetail(id);
        return JsonResult.success(baseProduce);
    }

    @ApiOperation(value = "查询款式详情")
    @GetMapping("/customer/produce/queryProduceDetail2")
    public JsonResult<QueryProduceDetailResp> queryProduceDetail2(@RequestParam Integer id) {

        BaseProduce produce = baseProduceService.getProduceForDetail(id);
        QueryProduceDetailResp data = new QueryProduceDetailResp();
        data.setProduce(produce);
        data.setServe(produce.getServe());
        return JsonResult.success(data);
    }


    @PostMapping("/customer/serve/praiseProduce")
    @ApiOperation(value = "款式点赞和取消点赞", notes = "款式点赞")
    public JsonResult<Void> praiseProduce(@RequestHeader String token,
                                          @RequestParam Integer produceId) {
        baseProduceService.praiseProduce(produceId);
        return JsonResult.success();
    }


}
