package com.gogirl.interfaces.product.mall;

import com.gogirl.application.product.mall.MallShoppingCartCmdService;
import com.gogirl.application.product.mall.MallShoppingCartQryService;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.shared.product.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@Api(tags = "商城购物车接口")
@RestController
@AllArgsConstructor
public class MallShoppingCartController {

    private final MallShoppingCartQryService mallShoppingCartQryService;
    private final MallShoppingCartCmdService mallShoppingCartCmdService;

    @ApiOperation("添加购物车")
    @PostMapping("/customer/mallCart/addMallShoppingCart")
    public JsonResult<Void> addMallShoppingCart(@RequestBody
                                                @Valid MallShoppingCartCommand cmd) {
        cmd.setCustomerId(SessionUtils.getCustomerId());
        mallShoppingCartCmdService.addMallShoppingCart(cmd);
        return JsonResult.success();
    }

    @AuthIgnore
    @ApiOperation("查看我的购物车")
    @PostMapping("/customer/mallCart/listMallShoppingCart")
    public JsonResult<MyMallShoppingCartDTO> listMallShoppingCart() {
        MyShoppingCartQuery qry = new MyShoppingCartQuery(SessionUtils.getCustomerId());
        MyMallShoppingCartDTO myMallShoppingCartDTO = mallShoppingCartQryService.queryMyShoppingCart(qry);
        return JsonResult.success(myMallShoppingCartDTO);
    }

    @ApiOperation("清空购物车")
    @GetMapping("/customer/mallCart/removeAllMallShoppingCart")
    public JsonResult<Void> removeAllMallShoppingCart() {
        RemoveAllCartCommand cmd = new RemoveAllCartCommand(SessionUtils.getCustomerId());
        mallShoppingCartCmdService.removeAllMallShoppingCart(cmd);
        return JsonResult.success();
    }

    @ApiOperation("删除购物车项")
    @GetMapping("/customer/mallCart/removeMallShoppingCart/{id}")
    public JsonResult<Integer> removeMallShoppingCart(@ApiParam("购物车id")
                                                      @PathVariable Long id) {
        mallShoppingCartCmdService.removeMallShoppingCart(new RemoveCartCommand(id));
        return JsonResult.success();
    }

    @ApiOperation("减少购物车项")
    @GetMapping("/customer/mallCart/decreaseMallShoppingCart/{id}")
    public JsonResult<Integer> decreaseMallShoppingCart(@ApiParam("产品id")
                                                        @PathVariable Long id) {
        mallShoppingCartCmdService.decreaseMallShoppingCart(new DecreaseCartCommand(SessionUtils.getCustomerId(), id));
        return JsonResult.success();
    }


}
