package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.user.customer.Customer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * Created by yinyong on 2018/9/28.
 */
@ApiModel("预约表")
@TableName("scheduled_manage")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ScheduleManage implements Serializable {


    //已预约
    public static final Integer STATUS_SCHEDULED = 1;
    //守约(已完成)
    public static final Integer STATUS_KEEP_SCHEDULED = 2;
    //失约
    public static final Integer STATUS_MISS_SCHEDULED = 3;
    //取消预约
    public static final Integer STATUS_CANCEL_SCHEDULED = 4;

    public static final Integer STATUS_DELETED = 5;

    //服务中
    public static final Integer STATUS_SERVING = 8;
    //用户端预约
    public static final Integer TYPE_CUSTOMER = 1;
    //店铺段预约
    public static final Integer TYPE_STORE = 2;

    @TableId(type = IdType.AUTO)
    @ApiModelProperty("选时间的时候就新建的id(删除状态),在确定预约按钮改为已预约状态")
    private Integer id;

    @ApiModelProperty("预约订单号")
    private String scheduledNo;

    @ApiModelProperty("下单人id")
    private Integer scheduledUser;

    @ApiModelProperty("店铺端预约手机号码")
    private String telephone;

    @ApiModelProperty("店铺端预约用户名")
    private String storeScheduleUsername;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("创建人")
    private String createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("预约时间")
    private Date scheduledTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("最近修改时间")
    private Date lastUpdateTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("预约到达时间")
    private Date arriveTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("上次服务时间")
    private Date lastServiceTime;

    @ApiModelProperty("到店人")
    private String arriveUser;

    @ApiModelProperty("下单店铺id")
    private Integer departmentId;

    //
    @ApiModelProperty("下单店铺名称")
    private String departmentName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("删除备注")
    private String delRemark;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开单时间")
    private Date openbillTime;

    @ApiModelProperty("预约类型")
    private Integer scheduledType;

    @ApiModelProperty("已预约#1 守约#2 失约#3  已取消#4 已删除#5 8服务中")
    private Integer status;

    @ApiModelProperty("预约关联的的订单")
    private Integer orderId;

    @Deprecated
    @TableField(exist = false)
    @ApiModelProperty("删除备注")
    private String delRemaerk;

    @TableField(exist = false)
    @ApiModelProperty("删除服务字段")
    private String deleteServe;

    @TableField(exist = false)
    @ApiModelProperty("提醒类型")
    private Integer remindStatus;

    @TableField(exist = false)
    @ApiModelProperty("已读状态")
    private Integer isRead;

    @TableField(exist = false)
    @ApiModelProperty("统计开始时间")
    private String startTime;

    @TableField(exist = false)
    @ApiModelProperty("统计结束时间")
    private String endTime;

    @TableField(exist = false)
    @ApiModelProperty("分页查询当天预约")
    private String sameDayTime;

    @TableField(exist = false)
    @ApiModelProperty("发送服务通知需要的formId")
    private String formId;

    @ApiModelProperty("是否发送过预约提醒 1是 2否")
    private Integer isSend;

    @ApiModelProperty("是否发送过预约提醒 1是 2否")
    private Integer isSendOverTime;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("token")
    private String token;

    @TableField(exist = false)
    @ApiModelProperty("预约时间")
    private String scheduleDate;

    @TableField(exist = false)
    @ApiModelProperty("去重的预约下服务列表")
    private Set<ScheduleServe> listScheduleServer = new TreeSet<>(Comparator.comparing(o -> o.getSchId() + ";" + o.getServeId()));

    @TableField(exist = false)
    private List<ScheduleServe> scheduleServeList;

    @TableField(exist = false)
    @ApiModelProperty("预约用户信息")
    private Customer customer;

    @Version
    private Integer version;

    @ApiModelProperty("品牌id")
    private Integer brandId;

    public void addScheduleServeList(Collection<ScheduleServe> scheduleServes) {
        listScheduleServer.addAll(scheduleServes);
    }
}
