package com.gogirl.application.common.xcx;


import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.user.customer.Customer;

import java.util.Date;

public interface GogirlTokenService {

    /**
     * 保存token
     *
     * @param gogirlToken
     */
    void save(GogirlToken gogirlToken);

    /**
     * 获取token
     *
     * @param token
     * @return
     */
    GogirlToken getByToken(String token);


    /**
     * 更新token
     *
     * @param gogirlToken
     */
    void updateByToken(GogirlToken gogirlToken);


    /**
     * 删除token
     *
     * @param token
     */
    void remove(String token);

    /**
     * 手机发送验证码
     *
     * @param phone
     * @return
     */
    String getBindCode(String phone);

    /**
     * 小程序用户根据验证码绑定手机号码和称呼
     *
     * @param phone
     * @param code
     * @param realName
     * @param birthday
     * @param sex
     * @return
     */
    Customer bindPhoneAndCode(String phone, String code, String realName, Date birthday, String sex) throws Exception;

    /**
     * 美甲师绑定手机号
     *
     * @param phone
     * @param code
     * @param messageCode
     */
    void bindTechnicianIdPhone(String phone, String code, String messageCode, Integer brandId);
}
