package com.gogirl.domain.market.coupon;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.user.customer.Customer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel("优惠券领取记录表")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName("coupon_customer_relevance")
@Data
public class CouponCustomerRelevance implements Serializable {

    public static Integer STATE_CHOSE = 1;
    public static Integer STATE_USED = 2;
    public static Integer SOURCE_TYPE_INNER = 0;
    public static Integer SOURCE_TYPE_OUTER = 1;
    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("顾客Id")
    private Integer customerId;
    @ApiModelProperty("卡券id")
    private Integer couponId;

    @ApiModelProperty("该优惠券使用状态1.正常,2.已使用,3.已过期")
    private Integer state;

    @ApiModelProperty("领奖码")
    private String code;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date receiveTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validStartTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date validEndTime;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date useDate;

    //冗余coupon字段
    private String remark;
    @TableField(exist = false)
    private Boolean canBeUse;
    @TableField(exist = false)
    private Coupon coupon;
    @TableField(exist = false)
    private Customer customer;
    private String couponName;
    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;
    @ApiModelProperty("满这个金额才能减")
    private BigDecimal reachingAmount;
    @ApiModelProperty("优惠折扣")
    private BigDecimal discountPercent;
    @ApiModelProperty("优惠券类型:1.现金抵扣券;2.免单券；3满减券；4卸甲券")
    private Integer type;
    @ApiModelProperty("0 = 内部券 1 = 外部券")
    private Integer sourceType;
    @ApiModelProperty("使用条件:1.重叠使用")
    private String condition1;
    @ApiModelProperty("客户购买该券时，实际支付的金额(用该金额算业绩)")
    private BigDecimal payAmount;
    @ApiModelProperty("卡券来源")
    private String sourceFrom;

    @ApiModelProperty("卡券来源id")
    private String sourceFromId;

    private Integer orderId;

    @ApiModelProperty("1-计算 2-不计算")
    private Integer isCalcAchievement = 1;

    /**
     * 根据优惠券配置构造一张优惠券
     *
     * @param coupon 优惠券配置
     * @return
     */
    public static CouponCustomerRelevance getInstance(Coupon coupon) {
        CouponCustomerRelevance customerRelevance = CouponCustomerRelevance.builder()
                .customerId(coupon.getId())
                .condition1(coupon.getCondition1())
                .couponId(coupon.getId())
                .couponName(coupon.getName())
                .discountAmount(coupon.getDiscountAmount())
                .discountPercent(coupon.getDiscountPercent())
                .payAmount(coupon.getPayAmount())
                .reachingAmount(coupon.getReachingAmount())
                .receiveTime(new Date())
                .sourceFrom("tech")
                .sourceType(CouponCustomerRelevance.SOURCE_TYPE_OUTER)
                .type(coupon.getType())
                .state(CouponCustomerRelevance.STATE_CHOSE)
                .build();
        if (coupon.getValidType().equals(1)) {
            customerRelevance.setValidStartTime(coupon.getValidStartTime());
            customerRelevance.setValidEndTime(coupon.getValidEndTime());
        } else {
            long startMills = System.currentTimeMillis();
            long endMills = startMills + coupon.getValidDate() * 24 * 60 * 60 * 1000;
            Date startTime = new Date(startMills);
            Date endTime = new Date(endMills);
            customerRelevance.setValidStartTime(startTime);
            customerRelevance.setValidEndTime(endTime);
        }
        return customerRelevance;
    }


    public boolean isValid() {
        return validStartTime.getTime() <= System.currentTimeMillis()
                && validEndTime.getTime() >= System.currentTimeMillis();
    }


}
