package com.gogirl.application.store.store.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.store.StoreDataService;
import com.gogirl.domain.store.store.StoreData;
import com.gogirl.domain.store.store.StoreTechnicianAchieve;
import com.gogirl.domain.store.store.StoreTechnicianTotalAchieve;
import com.gogirl.domain.store.store.StoreTradeAmount;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.mapper.store.store.StoreDataMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class StoreDataServiceImpl extends ServiceImpl<StoreDataMapper, StoreData> implements StoreDataService {

    private final StoreDataMapper storeDataMapper;

    @Override
    public StoreData storeData(String month) {
        Integer technicianId = SessionUtils.getTechnicianId();
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        StoreData storeData = storeDataMapper.selectOne(new LambdaQueryWrapper<StoreData>().eq(StoreData::getDepartmentId, gogirlToken.getDepartmentId()));
        //总订单业绩
        List<StoreTradeAmount> storeTradeAmountList = storeDataMapper.storeTradeAmount(month);

        //总开卡业绩
        StoreTradeAmount storeTradeAmount = new StoreTradeAmount();
        storeTradeAmount.setAmount(storeDataMapper.chargeAchieve(month));
        storeTradeAmount.setServeType("开卡");
        storeTradeAmountList.add(storeTradeAmount);

        //个人业绩
        List<StoreTechnicianAchieve> storeTechnicianAchieveList = storeDataMapper.storeTechnicianAchieve(month);
        storeData.setStoreTradeAmountList(storeTradeAmountList);
        storeData.setStoreTechnicianAchieveList(storeTechnicianAchieveList);

        //总业绩排行
        List<StoreTechnicianTotalAchieve> storeTechnicianTotalAchieveList = storeTechnicianAchieveList.stream().collect(Collectors.groupingBy(StoreTechnicianAchieve::getTechnicianId))
                .values().stream().map(list -> {
                    StoreTechnicianTotalAchieve storeTechnicianTotalAchieve = new StoreTechnicianTotalAchieve();
                    storeTechnicianTotalAchieve.setAchievement(list.stream().map(StoreTechnicianAchieve::getAchievement).reduce(BigDecimal.ZERO, BigDecimal::add));
                    storeTechnicianTotalAchieve.setTechnicianId(list.stream().map(StoreTechnicianAchieve::getTechnicianId).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianName(list.stream().map(StoreTechnicianAchieve::getTechnicianName).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianPicture(list.stream().findAny().get().getTechnicianPicture());

                    return storeTechnicianTotalAchieve;
                })
                .sorted(Comparator.comparing(StoreTechnicianTotalAchieve::getAchievement).reversed())
                .collect(Collectors.toList());

        storeData.setStoreTechnicianTotalAchieveList(storeTechnicianTotalAchieveList);

        //总订单业绩排行
        List<StoreTechnicianTotalAchieve> storeTechnicianTotalOrderAchieveList = storeTechnicianAchieveList.stream()
                .filter(storeTechnicianAchieve -> !storeTechnicianAchieve.getServeType().equals("开卡"))
                .collect(Collectors.groupingBy(StoreTechnicianAchieve::getTechnicianId))
                .values().stream().map(list -> {
                    StoreTechnicianTotalAchieve storeTechnicianTotalAchieve = new StoreTechnicianTotalAchieve();
                    storeTechnicianTotalAchieve.setAchievement(list.stream().map(StoreTechnicianAchieve::getAchievement).reduce(BigDecimal.ZERO, BigDecimal::add));
                    storeTechnicianTotalAchieve.setTechnicianId(list.stream().map(StoreTechnicianAchieve::getTechnicianId).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianName(list.stream().map(StoreTechnicianAchieve::getTechnicianName).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianPicture(list.stream().findAny().get().getTechnicianPicture());

                    return storeTechnicianTotalAchieve;
                })
                .sorted(Comparator.comparing(StoreTechnicianTotalAchieve::getAchievement).reversed())
                .collect(Collectors.toList());

        storeData.setStoreTechnicianTotalOrderAchieveList(storeTechnicianTotalOrderAchieveList);


        //总充值业绩排行
        List<StoreTechnicianTotalAchieve> storeTechnicianTotalChargeAchieveList = storeTechnicianAchieveList.stream()
                .filter(storeTechnicianAchieve -> storeTechnicianAchieve.getServeType().equals("开卡"))
                .collect(Collectors.groupingBy(StoreTechnicianAchieve::getTechnicianId))
                .values().stream().map(list -> {
                    StoreTechnicianTotalAchieve storeTechnicianTotalAchieve = new StoreTechnicianTotalAchieve();
                    storeTechnicianTotalAchieve.setAchievement(list.stream().map(StoreTechnicianAchieve::getAchievement).reduce(BigDecimal.ZERO, BigDecimal::add));
                    storeTechnicianTotalAchieve.setTechnicianId(list.stream().map(StoreTechnicianAchieve::getTechnicianId).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianName(list.stream().map(StoreTechnicianAchieve::getTechnicianName).findAny().orElse(null));
                    storeTechnicianTotalAchieve.setTechnicianPicture(list.stream().findAny().get().getTechnicianPicture());

                    return storeTechnicianTotalAchieve;
                })
                .sorted(Comparator.comparing(StoreTechnicianTotalAchieve::getAchievement).reversed())
                .collect(Collectors.toList());

        storeData.setStoreTechnicianTotalChargeAchieveList((storeTechnicianTotalChargeAchieveList));
        return storeData;
    }
}
