package com.gogirl.shared.order;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel("商城下单参数")
public class MallOrderDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("交易方式 ")
    private Integer transactionType;

    @ApiModelProperty("下单时间")
    private Long orderTime;

    @ApiModelProperty("支付时间")
    private Long paymentTime;

    @ApiModelProperty("订单总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("运费")
    private BigDecimal freight;

    @ApiModelProperty("总优惠金额")
    private BigDecimal totalDiscountAmount;

    @ApiModelProperty("实际支付总金额")
    private BigDecimal totalPayAmount;

    @ApiModelProperty("配送方式 1-邮寄 2-自取")
    private Integer transportMode;

    @ApiModelProperty("支付方式 1-线上支付")
    private Integer paymentType;

    @ApiModelProperty("订单类型")
    private Integer type;

    @ApiModelProperty("订单状态 1-订单待付款 2-订单已付款 3-订单已发货 4-订单已签收")
    private Integer status;

    @ApiModelProperty("顾客留言备注")
    private String customerRemark;

    @ApiModelProperty(value = "配送地址id", required = true)
    private Long mallCustomerAddressId;

    @ApiModelProperty("订单详情")
    private List<MallOrderDetailDTO> mallOrderDetailDTOList;

    private MallOrderAddressDTO mallOrderAddressDTO;
    //todo 优惠详情


}
