package com.gogirl.application.order.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.common.IAgentUserService;
import com.gogirl.application.order.mall.MallOrderDetailService;
import com.gogirl.application.order.mall.MallOrderPayService;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.application.user.customer.CustomerService;
import com.gogirl.domain.common.AgentUser;
import com.gogirl.domain.order.mall.MallOrder;
import com.gogirl.domain.order.mall.MallOrderDetail;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.domain.user.customer.CustomerMessage;
import com.gogirl.infrastructure.common.config.property.GogirlProperties;
import com.gogirl.infrastructure.common.config.property.WxProperties;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.common.AgentUserMapper;
import com.gogirl.infrastructure.mapper.order.mall.MallOrderMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMessageMapper;
import com.gogirl.infrastructure.service.wx.WxPayService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 商城订单支付服务
 */
@Service
@Slf4j
@AllArgsConstructor
@Transactional
public class MallOrderPayServiceImpl implements MallOrderPayService {

    private final GogirlProperties gogirlProperties;
    private final CustomerService customerService;
    private final WxPayService wxPayService;

    private final MallOrderDetailService mallOrderDetailService;
    private final MallOrderMapper mallOrderMapper;

    private final CustomerBalanceService customerBalanceService;
    private final CustomerBalanceRecordMapper customerBalanceRecordMapper;
    private final CustomerMessageMapper customerMessageMapper;

    private final WxProperties wxProperties;

    private final IAgentUserService agentUserService;


    private WxPayUnifiedOrderRequest buildPayParam(MallOrder mallOrder) throws UnknownHostException {
        Customer customer = customerService.getById(mallOrder.getCustomerId());
        //代理打折
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String ip = Inet4Address.getLocalHost().getHostAddress();

        WxPayUnifiedOrderRequest request = WxPayUnifiedOrderRequest.newBuilder()
                .outTradeNo(String.valueOf(mallOrder.getId()))
                .totalFee(mallOrder.getTotalPayAmount().multiply(new BigDecimal(100)).intValue())
                .notifyUrl(gogirlProperties.getNotifyMallOrder())
                .timeStart(df.format(new Date()))
                .spbillCreateIp(ip)
                .tradeType("JSAPI")
                .body("gogirl美甲")
                .openid(customer.getOpenid1())
                .build();
        request.setAppid(wxProperties.getCustomerMiniAppId());
        return request;
    }

    @Override
    public WxPayMpOrderResult wxPayMallOrder(Integer currentCustomerId, Long orderId) throws UnknownHostException, WxPayException {
        MallOrder mallOrder = mallOrderMapper.selectById(orderId);
        mallOrder.setPaymentCustomerId(currentCustomerId);

        mallOrderMapper.updateById(mallOrder);

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest = this.buildPayParam(mallOrder);
        return wxPayService.createJsapiOrder(wxPayUnifiedOrderRequest);
    }

    @Resource
    AgentUserMapper agentUserMapper;


    @Transactional(timeout = 10000)
    @Override
    public void balancePayMallOrder(Integer currentCustomerId, Long orderId) {

        MallOrder mallOrder = mallOrderMapper.selectById(orderId);

        Customer customer = customerService.getById(currentCustomerId);

        AgentUser agentUser = agentUserMapper.selectOne(new LambdaQueryWrapper<AgentUser>()
                .eq(AgentUser::getPhone, customer.getPhone()));
        if (agentUser == null) {
            throw new RRException(ErrorCode.ER_2007);
        }
        agentUserService.addBalanceLog(2, mallOrder.getTotalPayAmount(), agentUser.getId());


        mallOrder.setStatus(MallOrder.STATUS_UN_SHIP);
        //支付时间
        mallOrder.setPaymentTime(System.currentTimeMillis());
        //支付方式
        mallOrder.setPaymentType(MallOrder.PAYMENT_TYPE_BALANCE);
        mallOrderMapper.updateById(mallOrder);

        List<MallOrderDetail> mallOrderDetailList = mallOrderDetailService.list(new LambdaQueryWrapper<MallOrderDetail>().eq(MallOrderDetail::getOrderId, orderId));
        mallOrderDetailList.forEach(mallOrderDetail -> mallOrderDetail.setRefundStatus(0));
        mallOrderDetailService.updateBatchById(mallOrderDetailList);

        log.info("商城订单支付成功回调 :{}", orderId);


    }

    @Override
    public WxPayMpOrderResult balanceWxPayMallOrder(Integer currentCustomerId, Long orderId) {
        return null;
    }

    @Override
    public void friendPayMallOrder(Integer currentCustomerId, Long orderId, String phone) {

        Customer customer = customerService.selectByPhone(phone);
        if (customer == null) {
            throw new RRException(500, "用户不存在");
        }

        Map<String, Object> params = new HashMap<>();
        params.put(CustomerMessage.PARAM_FRIEND_PAY_ORDER_ID, orderId);
        params.put(CustomerMessage.PARAM_FRIEND_PAY_CUSTOMER_ID, currentCustomerId);
        String paramsJson = JsonUtilByFsJson.beanToJson(params);

        List<CustomerMessage> list = customerMessageMapper.selectList(new LambdaQueryWrapper<CustomerMessage>().eq(CustomerMessage::getParamsJson, paramsJson));

        //避免重复发送
        if (ListUtil.isEmpty(list)) {
            CustomerMessage customerMessage = CustomerMessage.builder()
                    .customerId(customer.getId())
                    .header("代付订单提醒")
                    .paramsJson(paramsJson)
                    .status(CustomerMessage.STATUS_UN_READ)
                    .type(CustomerMessage.TYPE_FRIEND_PAY)
                    .build();
            //保存消息
            customerMessageMapper.insert(customerMessage);
        }
    }

    @Override
    public void notifyMallOrder(Long orderId) {

        MallOrder mallOrder = mallOrderMapper.selectById(orderId);
        mallOrder.setStatus(MallOrder.STATUS_UN_SHIP);
        //支付时间
        mallOrder.setPaymentTime(System.currentTimeMillis());
        //支付方式
        mallOrder.setPaymentType(MallOrder.PAYMENT_TYPE_WX);
        mallOrderMapper.updateById(mallOrder);

        List<MallOrderDetail> mallOrderDetailList = mallOrderDetailService.list(new LambdaQueryWrapper<MallOrderDetail>().eq(MallOrderDetail::getOrderId, orderId));
        mallOrderDetailList.forEach(mallOrderDetail -> mallOrderDetail.setRefundStatus(0));
        mallOrderDetailService.updateBatchById(mallOrderDetailList);

        log.info("商城订单支付成功回调 :{}", orderId);
    }

    @Override
    public void refund(Long orderDetailId) throws WxPayException {
//
//        MallOrder mallOrder = mallOrderService.getById(orderDetailId);
//        MallRefundOrder mallRefundOrder = mallRefundOrderService.getOne(new LambdaQueryWrapper<MallRefundOrder>()
//                .eq(MallRefundOrder::getMallOrderId, orderDetailId));
//
//        //
//        WxPayRefundRequest refundRequest = WxPayRefundRequest.newBuilder()
//                .notifyUrl(gogirlProperties.getNotifyRefundMallOrder())
//                .outTradeNo(String.valueOf(orderDetailId))
//                .outRefundNo(String.valueOf(mallRefundOrder.getId()))
//                .totalFee(mallOrder.getTotalPayAmount().intValue() * 100)
//                .refundFee(mallRefundOrder.getRefundTotalAmount().intValue() * 100)
//                .build();
//
//        refundRequest.setAppid(wxProperties.getCustomerMiniAppId());
//        wxPayControllerFeign.refund(refundRequest);

    }
}
