package com.gogirl.domain.store.training;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

@TableName("training_start_class")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TrainingStartClass implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer courseId;

    private String lecturer;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    private Integer duration;

    private Integer status;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @TableField(exist = false)
    private TrainingCourse trainingCourse;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("学员反馈")
    private String feedback;

    @ApiModelProperty("图片")
    private String picture_path;
}
