package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.mall.MallProductService;
import com.gogirl.domain.product.mall.MallCategory;
import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.infrastructure.mapper.product.mall.MallCategoryMapper;
import com.gogirl.infrastructure.mapper.product.mall.MallProductMapper;
import com.gogirl.shared.product.ProductQuery;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
public class MallProductServiceImpl extends ServiceImpl<MallProductMapper, MallProduct> implements MallProductService {

    private final MallProductMapper mallProductMapper;
    private final MallCategoryMapper mallCategoryMapper;

    @Override
    public IPage<MallProduct> queryPageProduct(ProductQuery qry) {
        IPage<MallProduct> productIPage = new Page<>();
        return mallProductMapper.queryPageProduct(productIPage, qry);
    }

    @Override
    public MallProduct queryProduct(Long mallProductId) {
        MallProduct mallProduct = this.getById(mallProductId);
        List<MallProduct> serialMallProductList = this.list(new LambdaQueryWrapper<MallProduct>()
                .eq(MallProduct::getParentId, mallProduct.getParentId()));

        List<MallCategory> mallCategoryList = mallCategoryMapper.selectByProduceId(mallProduct.getId());
        mallProduct.setSerialProductList(serialMallProductList);
        mallProduct.setCategoryName(mallCategoryList.stream().findAny().map(MallCategory::getCategoryName).orElse("甲油胶"));

        return mallProduct;
    }
}
