package com.gogirl.interfaces.product.mall;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.product.mall.MallProductService;
import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.product.ProductQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@AllArgsConstructor
@Api(tags = "version3.0:商城产品接口", value = "version3.0:商城产品接口")
public class MallProductController {

    private final MallProductService mallProductService;

    @ApiOperation("分页查询商城产品列表")
    @PostMapping("/customer/mallProduct/queryPageProduct")
    public JsonResult<Page<MallProduct>> queryPageProduct(@RequestBody ProductQuery qry) {

        IPage<MallProduct> page = mallProductService.queryPageProduct(qry);
        return JsonResult.success((Page<MallProduct>) page);
    }

    @ApiOperation("查询商城产品详情")
    @GetMapping("/customer/mallProduct/queryProduct")
    public JsonResult<MallProduct> queryProduct(@RequestParam Long mallProductId) {

        MallProduct mallProduct = mallProductService.queryProduct(mallProductId);
        return JsonResult.success(mallProduct);
    }

}
