package com.gogirl.infrastructure.service.push.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.order.serve.ScheduleServe;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleManageMapper;
import com.gogirl.infrastructure.mapper.order.serve.ScheduleServeMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.infrastructure.service.push.PushMsgService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2021/3/4 9:41 上午
 */
@ActiveProfiles("prod")
@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
@EnableAsync
public class MiniappPushMsgServiceImplTest {

    @Resource
    ScheduleManageMapper scheduleManageMapper;
    @Resource
    ScheduleServeMapper scheduleServeMapper;
    @Resource
    PushMsgService pushMsgService;
    @Resource
    CustomerMapper customerMapper;
    @Resource
    StoreManageMapper storeManageMapper;

    @Test
    public void sendScheduleMsg() {
        ScheduleManage scheduleManage = scheduleManageMapper.selectOne(new LambdaQueryWrapper<ScheduleManage>().eq(
                ScheduleManage::getScheduledNo, "TYD2103040012"
        ));

        List<ScheduleServe> scheduleServeList = scheduleServeMapper.selectList(new LambdaQueryWrapper<ScheduleServe>()
                .eq(ScheduleServe::getSchId, scheduleManage.getId()));

        Customer customer = customerMapper.selectById(scheduleManage.getScheduledUser());

        StoreManage storeManage = storeManageMapper.selectById(scheduleManage.getDepartmentId());

        pushMsgService.sendScheduleMsg(customer.getOpenid1(), scheduleServeList.get(0).getServeName(), scheduleManage.getArriveTime(), scheduleManage.getDepartmentName(), storeManage.getShortAddress());
    }
}
