package com.gogirl.domain.order.sys;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <p>
 * 微信订单流水
 * </p>
 *
 * @author robbendev
 * @since 2020-12-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "WxOrderFlow对象", description = "微信订单流水")
public class WxOrderFlow implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final Integer SCHEDULE_ORDER = 1;
    public static final Integer CHARGE_ORDER = 2;
    public static final Integer TIMES_CARD = 3;
    public static final Integer AGENT_CHARGE = 3;

    public static final Integer CUSTOMER = 1;
    public static final Integer TECHNICIAN = 2;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "用户在商户appid下的唯一标识")
    private String openid;

    @ApiModelProperty(value = "1-美甲沙龙小程序2-店员端小程序")
    private Integer sourceFrom;

    @ApiModelProperty(value = "JSA描述：PI、NATIVE、APP")
    private String tradeType;

    @ApiModelProperty(value = "银行类型，采用字符串类型的银行标识，银行类型见银行列表")
    private String bankType;

    @ApiModelProperty(value = "订单总金额，单位为分")
    private Integer totalFee;

    @ApiModelProperty(value = "货币类型，符合ISO4217标准的三位字母代码，默认人民币：CNY，其他值列表详见货币类型")
    private String feeType;

    @ApiModelProperty(value = "微信支付订单号")
    private String transactionId;

    @ApiModelProperty(value = "商户系统的订单号，与请求一致。")
    private String outTradeNo;

    @ApiModelProperty(value = "支付完成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。其他详见时间规则")
    private String timeEnd;

    @ApiModelProperty(value = "商户订单类型 ")
    private Integer orderType;

    public static WxOrderFlow getInstance(WxPayOrderNotifyResult result) {
        WxOrderFlow wxOrderFlow = new WxOrderFlow();
        wxOrderFlow.setOpenid(result.getOpenid());
        wxOrderFlow.setTradeType(result.getTradeType());
        wxOrderFlow.setBankType(result.getBankType());
        wxOrderFlow.setTotalFee(result.getTotalFee());
        wxOrderFlow.setFeeType(result.getFeeType());
        wxOrderFlow.setTransactionId(result.getTransactionId());
        wxOrderFlow.setOutTradeNo(result.getOutTradeNo());
        wxOrderFlow.setTimeEnd(result.getTimeEnd());
        return wxOrderFlow;
    }


}
