package com.gogirl.interfaces.product.serve;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.product.serve.IColorSystemService;
import com.gogirl.application.product.serve.IColorSystemTypeService;
import com.gogirl.domain.product.serve.ColorSystem;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 色系 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-03-09
 */
@RestController
@AllArgsConstructor
public class ColorSystemController {

    private final IColorSystemService colorSystemService;
    private final IColorSystemTypeService colorSystemTypeService;

    @ApiOperation("款式色系")
    @GetMapping("/customer/colorSystem/no_query/{id}")
    public JsonResult<List<ColorSystem>> query(@PathVariable Integer id) {
        List<ColorSystem> list = colorSystemService.query(id);
        return JsonResult.success(list);
    }

}
