package com.gogirl.application.store.career.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.store.career.ITechScoreRulesService;
import com.gogirl.domain.store.career.TechScoreRules;
import com.gogirl.dto.TechScoreResp;
import com.gogirl.dto.admin.AchievementsPersonaResult;
import com.gogirl.dto.admin.AchievementsPersonaResultPageApiRequest;
import com.gogirl.dto.admin.AdminPage;
import com.gogirl.dto.admin.AdminResult;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.mapper.store.career.CareerMapper;
import com.gogirl.infrastructure.mapper.store.career.TechScoreRulesMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@Service
public class TechScoreRulesServiceImpl extends ServiceImpl<TechScoreRulesMapper, TechScoreRules> implements ITechScoreRulesService {

    @Resource
    private CareerMapper careerMapper;
    @Resource
    RestTemplate restTemplate;
    @Resource
    GogirlProperties gogirlProperties;

    @Override
    public TechScoreResp getTechScore() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);

        Calendar calendar = Calendar.getInstance();
        AchievementsPersonaResultPageApiRequest resultPageApiRequest = AchievementsPersonaResultPageApiRequest.builder()
                .page(1)
                .year(calendar.get(Calendar.YEAR))
                .month(calendar.get(Calendar.MONTH)+1)
                .status(1)
                .page(1)
                .rows(30)
                .sidx("")
                .sord("desc")
                .technician_id(SessionUtils.getTechnicianId())
                .build();
        HttpEntity<AchievementsPersonaResultPageApiRequest> httpEntity = new HttpEntity<>(resultPageApiRequest, httpHeaders);
        ParameterizedTypeReference<AdminResult<AdminPage<AchievementsPersonaResult>>> responseBodyType = new ParameterizedTypeReference<AdminResult<AdminPage<AchievementsPersonaResult>>>() {
        };
        AdminResult<AdminPage<AchievementsPersonaResult>> result =
                restTemplate.exchange(gogirlProperties.getAdminBackendAchievementsUrl(), HttpMethod.POST, httpEntity, responseBodyType).getBody();

        AchievementsPersonaResult achievementsPersonaResult = result.getData().getItems().stream().findAny().orElseThrow(NullPointerException::new);

        TechScoreResp techScoreResp = new TechScoreResp();
        techScoreResp.setTechScore(achievementsPersonaResult.getMonth_score().doubleValue());

        List<TechScoreRules> techScoreRulesList = new ArrayList<>();
        String card = String.format("开卡得分：%s。开卡率：%s。权重:%s。规则：20%%该项满分、5%%该项0分。可以超过100分",
                achievementsPersonaResult.getActivate_a_card_score().toString(),
                achievementsPersonaResult.getActivate_a_card_val().toString()
                , achievementsPersonaResult.getActivate_a_card_proportion_str());
        TechScoreRules t1 = TechScoreRules.builder().sort(1).techScoreRules(card).build();
        techScoreRulesList.add(t1);

        //好评得分
        String comment = String.format("好评率得分：%s。好评率：%s。权重:%s。规则：分数=好评（>3星）数/总评论数*100，评论包括所有渠道投诉。"
                , achievementsPersonaResult.getPraise_score().toString()
                , achievementsPersonaResult.getPraise_val().toString()
                , achievementsPersonaResult.getPraise_proportion_str());
        TechScoreRules t2 = TechScoreRules.builder().sort(2).techScoreRules(comment).build();
        techScoreRulesList.add(t2);

        //服务准时得分
        String serviceTime = String.format("服务准时得分: %s。服务准时得分率：%s。权重: %s。规则：+10%%，-20%%以内为准。90%%出勤率为满分"
                , achievementsPersonaResult.getService_time_score().toString()
                , achievementsPersonaResult.getService_time_val().toString()
                , achievementsPersonaResult.getService_time_proportion_str());
        TechScoreRules t3 = TechScoreRules.builder().sort(3).techScoreRules(serviceTime).build();
        techScoreRulesList.add(t3);

        //店务得分
        String shop = String.format("店务得分：%s。权重:%s。规则：该项得分为满分，抽查发现问题时一个问题扣1分"
                , achievementsPersonaResult.getShop_item_score().toString()
                , achievementsPersonaResult.getShop_item_proportion_str());
        TechScoreRules t4 = TechScoreRules.builder().sort(4).techScoreRules(shop).build();
        techScoreRulesList.add(t4);

        //总分
        String total = String.format("总分:%s。规则：按月计算，达到满分以上奖励300元，低于80分罚500元", achievementsPersonaResult.getMonth_score().toString());
        TechScoreRules t5 = TechScoreRules.builder().sort(5).techScoreRules(total).build();
        techScoreRulesList.add(t5);

        techScoreResp.setTechScoreRulesList(techScoreRulesList);
        return techScoreResp;
    }
}
