package com.gogirl.domain.market.coupon;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel("优惠券配置")
@Data
@TableName("coupon")
public class Coupon implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("券名称")
    private String name;

    @ApiModelProperty("优惠金额")
    private BigDecimal discountAmount;

    @ApiModelProperty("满这个金额才能减")
    private BigDecimal reachingAmount;

    @ApiModelProperty("优惠折扣")
    private BigDecimal discountPercent;

    @DictParam(dictCode = "COUPON_TYPE", dictValueParam = "typeStr")
    @ApiModelProperty("优惠券类型:1.现金抵扣券;2.免单券；3满减券；4卸甲券；5 = 折扣券")
    private Integer type;

    @TableField(exist = false)
    private String typeStr;

    @ApiModelProperty("使用条件:1.重叠使用")
    private String condition1;

    @ApiModelProperty("优惠券说明")
    private String note;

    @DictParam(dictCode = "COUPON_VALID_TYPE", dictValueParam = "validTypeStr")
    @ApiModelProperty("有效期类型:1.开始和结束时间;2.有效天数")
    private Integer validType;

    @TableField(exist = false)
    private String validTypeStr;

    @ApiModelProperty("有效天数")
    private Integer validDate;

    @ApiModelProperty("0 = 内部券 1 = 外部券")
    @DictParam(dictCode = "COUPON_SOURCE_TYPE", dictValueParam = "sourceTypeStr")
    private Integer sourceType;

    @TableField(exist = false)
    private String sourceTypeStr;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("有效期,开始时间")
    private Date validStartTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("有效期,截止时间")
    private Date validEndTime;

    @ApiModelProperty("总数量")
    private Integer allQuantity;

    @ApiModelProperty("发放数量")
    private Integer receiveQuantity;

    @ApiModelProperty("使用次数")
    private Integer useQuantity;

    @ApiModelProperty("每人最多领取次数")
    private Integer limitQuantity;

    @DictParam(dictCode = "COUPON_STATE", dictValueParam = "stateStr")
    @ApiModelProperty("状态:1.启用;2.停止")
    private Integer state;

    @TableField(exist = false)
    private String stateStr;

    @ApiModelProperty("最近更新时间,用于排序")
    private Date updateTime;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("客户购买该券时，实际支付的金额(用该金额算业绩)")
    private BigDecimal payAmount;

    @ApiModelProperty("7:大众点评收款,10:免单(外部券购买时钱去到哪里了和customer_balance_record表的source字段保持一致)")
    private String paySource;

    @TableField(exist = false)
    @ApiModelProperty("是否可以使用")
    private Boolean canBeUse;

}
