package com.gogirl.application.user.customer.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.user.customer.IBeautyExpoQuestionnaireService;
import com.gogirl.domain.user.customer.BeautyExpoQuestionnaire;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.mapper.user.customer.BeautyExpoQuestionnaireMapper;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-07-24
 */
@Service
public class BeautyExpoQuestionnaireServiceImpl extends ServiceImpl<BeautyExpoQuestionnaireMapper, BeautyExpoQuestionnaire> implements IBeautyExpoQuestionnaireService {

    @Override
    public void submitQuestionnaire(BeautyExpoQuestionnaire beautyExpoQuestionnaire) {
        if (hasSubmitted(beautyExpoQuestionnaire.getCustomerId())) {
            throw new RRException(ErrorCode.CS_2003);
        }
        this.save(beautyExpoQuestionnaire);
    }

    @Override
    public Boolean hasSubmitted(Integer customerId) {
        BeautyExpoQuestionnaire questionnaire = this.getOne(new LambdaQueryWrapper<BeautyExpoQuestionnaire>().eq(BeautyExpoQuestionnaire::getCustomerId, customerId));
        return questionnaire != null;
    }
}
