package com.gogirl.interfaces.order.serve;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.gogirl.domain.order.serve.OrderCommentLabel;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.order.serve.OrderCommentLabelMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * Created by yinyong on 2018/10/22.
 */

@Api(tags = {"预约订单评论标签接口"}, value = "预约订单评论标签接口")
@RestController
@AllArgsConstructor
public class OrderCommentLabelController {

    private final OrderCommentLabelMapper orderCommentLabelMapper;

    /**
     * 查询所有评论标签
     *
     * @return 所有评论标签列表
     */
    @ApiOperation(value = "查询所有标签")
    @GetMapping("/customer/orderlabel/queryOrderLabel")
    public JsonResult<Map<Integer, List<OrderCommentLabel>>> queryOrderLabel() {
        List<OrderCommentLabel> commentLabelList = orderCommentLabelMapper.selectList(new QueryWrapper<>());

        List<OrderCommentLabel> commonLabel = commentLabelList.stream().filter(orderCommentLabel -> orderCommentLabel.getServeTypeId() == null).collect(Collectors.toList());

        Map<Integer, List<OrderCommentLabel>> map = commentLabelList.stream().filter(orderCommentLabel -> orderCommentLabel.getServeTypeId() != null)
                .collect(Collectors.groupingBy(OrderCommentLabel::getServeTypeId));

        if (ListUtil.isNotEmpty(map.get(0))) {
            commonLabel.addAll(map.get(0));
        }
        map.remove(0);
        map.forEach((id, commentLabelListVar) -> {
            commentLabelListVar.addAll(commentLabelList);
        });
        return JsonResult.success(map);
    }
}
