package com.gogirl.interfaces.product.serve;


import com.gogirl.application.product.serve.ITechniqueSkuService;
import com.gogirl.domain.product.serve.TechniqueCategory;
import com.gogirl.domain.product.serve.TechniqueSku;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 技法sku 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Api(tags = "款式技法接口")
@RestController
public class TechniqueSkuController {
    @Resource
    ITechniqueSkuService techniqueSkuService;

    @ApiOperation("查询所有款式技法")
    @GetMapping("/technician/techniqueSku/queryAll")
    public JsonResult<List<TechniqueSku>> queryAll(@RequestHeader("brandId") Integer brandId) {
        List<TechniqueSku> techniqueSkuList = techniqueSkuService.queryAll(brandId);
        return JsonResult.success(techniqueSkuList);
    }


    @Deprecated
    @ApiOperation("查询所有款式技法分组")
    @GetMapping("/technician/techniqueSku/queryMap")
    public JsonResult<Map<String, List<TechniqueSku>>> queryMap(@RequestHeader("brandId") Integer brandId) {
        List<TechniqueSku> techniqueSkuList = techniqueSkuService.queryAll(brandId);
        return JsonResult.success(techniqueSkuList.stream().collect(Collectors.groupingBy(TechniqueSku::getTechniqueCategoryName)));
    }


    @ApiOperation("查询所有款式技法分组")
    @GetMapping("/technician/techniqueSku/queryTechniqueSkuMap")
    public JsonResult<Map<String, List<TechniqueSku>>> queryTechniqueSkuMap(@RequestHeader("brandId") Integer brandId) {
        Map<String, List<TechniqueSku>> map = techniqueSkuService.queryTechniqueSkuMap(brandId);
        return JsonResult.success(map);
    }

    @ApiOperation("查询所有款式技法分组")
    @GetMapping("/technician/techniqueSku/queryTechniqueCategoryAggregate")
    public JsonResult<List<TechniqueCategory>> queryTechniqueCategoryAggregate(@RequestParam(required = false) Integer scheduleServeId,
                                                                               @RequestParam(required = false) Integer orderServeId,
                                                                               @RequestParam(required = false) Integer serveId,
                                                                               @RequestHeader("brandId") Integer brandId) {
        List<TechniqueCategory> techniqueCategoryList = techniqueSkuService.queryTechniqueCategoryAggregate(scheduleServeId, orderServeId, serveId, brandId);
        return JsonResult.success(techniqueCategoryList);
    }

}
