package com.gogirl.application.market.discount.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.discount.LeisureDiscountConfigService;
import com.gogirl.domain.market.discount.LeisureDiscountConfig;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

@Service
@AllArgsConstructor
public class LeisureDiscountConfigServiceImpl extends ServiceImpl<LeisureDiscountConfigMapper, LeisureDiscountConfig> implements LeisureDiscountConfigService {

    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;

    @Override
    public LeisureDiscountConfig queryMinDiscount(Integer brandId) {
        return leisureDiscountConfigMapper.selectOne(
                new LambdaQueryWrapper<LeisureDiscountConfig>()
                        .eq(LeisureDiscountConfig::getIsEnabled, 1)
                        .eq(LeisureDiscountConfig::getBrandId, brandId)
                        .orderByAsc(LeisureDiscountConfig::getDiscountRate)
                        .last("limit 1"));
    }
}
