package com.gogirl.shared.order;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.gogirl.domain.store.store.StoreTechnician;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class StoreTechnicianPeriod implements Serializable {

    /**
     * 美甲师的不可用时间段
     */
    @JsonIgnore
    List<Period> periodList;

    /**
     * 最晚可约时间
     */
    @JsonIgnore
    long latestScheduledTimeMills;

    /**
     * 美甲师下班时间
     */
    @JsonIgnore
    long workEndTime;

    /**
     * 美甲师休息时间
     */
    @JsonIgnore
    Period breakTime;

    /**
     * 超过最晚时间是否可约
     */
    @JsonIgnore
    Integer latestScheduledTimeEnable;
    /**
     * 美甲师id
     */
    private Integer technicianId;

    /**
     * 美甲师姓名
     */
    private String name;

    /**
     * 美甲师头像
     */
    private String picturePath;

    /**
     * 美甲师级别
     */
    private String grade;

    @JsonIgnore
    private StoreTechnician storeTechnician;

    public StoreTechnicianPeriod() {

    }


    public StoreTechnicianPeriod(List<Period> periodList, StoreTechnician storeTechnician, long latestScheduledTimeMills, Integer latestScheduledTimeEnable, long workEndTime, Period breakTime) {
        this.periodList = periodList;
        this.technicianId = storeTechnician.getId();
        this.name = storeTechnician.getName();
        this.picturePath = storeTechnician.getPicturePath();
        this.grade = storeTechnician.getGrade();
        this.storeTechnician = storeTechnician;
        this.latestScheduledTimeMills = latestScheduledTimeMills;
        this.latestScheduledTimeEnable = latestScheduledTimeEnable;
        this.workEndTime = workEndTime;
        this.breakTime = breakTime;
    }

}
