package com.gogirl.interfaces.store.shop;


import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.shared.store.UpdateDayTechnicianClassesReq;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Api(tags = {"美甲师排班接口"})
@RestController
@Slf4j
@AllArgsConstructor
public class ClassesTechnicianController {


    private final StoreClassesTechnicianService storeClassesTechnicianService;
    private final StoreClassesService storeClassesService;


    @ApiOperation(value = "美甲师端查询当天店铺排班")
    @GetMapping("/technician/classestechnician/queryDayTechnicianClasses")
    public JsonResult<List<StoreTechnician>> queryDayTechnicianClasses(String dayString) throws ParseException {
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        log.info("查询美甲师当当天排班 technicianId :{}", gogirlToken.getTechnicianId());
        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);
        Integer departmentId = gogirlToken.getDepartmentId();
        List<StoreTechnician> list = storeClassesTechnicianService.queryDayTechnicianClasses(departmentId, day);
        return JsonResult.success(list);
    }

    @ApiOperation(value = "美甲师端提交当天店铺排班")
    @PostMapping("/technician/classestechnician/updateDayTechnicianClasses")
    public JsonResult<Void> updateDayTechnicianClasses(@RequestBody UpdateDayTechnicianClassesReq request) throws ParseException {
        storeClassesTechnicianService.updateDayTechnicianClasses(request);
        return JsonResult.success();
    }


    @ApiOperation(value = "美甲师端查询当月排班排班")
    @GetMapping("/technician/classestechnician/queryMonthClasses")
    public JsonResult<List<StoreClassesTechnician>> queryMonthClasses(String month) {

        Integer departmentId = SessionUtils.getTechnicianToken().getDepartmentId();
        List<StoreClassesTechnician> lists = storeClassesService.queryMonthClasses(SessionUtils.getTechnicianId(), departmentId, month);
        return JsonResult.success(lists);
    }

}
