package com.gogirl.domain.market.discount;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("充送金额和折扣配置")
@TableName("discount_config")
@Data
public class DiscountConfig implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("总充金额达到")
    private Integer totalCharge;

    @ApiModelProperty("当次充值达到")
    private Integer chargeAmount;

    @ApiModelProperty("赠送金额")
    private Integer bestowAmount;

    @ApiModelProperty("获得折扣")
    private Double discount;

    @ApiModelProperty("会员等级")
    private String level;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("免单券id（充送免单券）")
    private Integer couponId;

    private String info;

    @ApiModelProperty("品牌id")
    private Integer brandId;
}
