package com.gogirl.interfaces.product.serve;


import com.gogirl.application.product.serve.IColorSystemService;
import com.gogirl.domain.product.serve.ColorSystem;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 色系 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-03-09
 */
@RestController
@AllArgsConstructor
@Api(tags = "首页色系接口")
public class ColorSystemController {

    private final IColorSystemService colorSystemService;

    @ApiOperation("款式色系 id=0:一级类目")
    @GetMapping("/customer/colorSystem/no_query/{id}")
    public JsonResult<List<ColorSystem>> query(@PathVariable Integer id,
                                               @RequestHeader("brandId") Integer brandId) {
        List<ColorSystem> list = colorSystemService.query(id, brandId);
        return JsonResult.success(list);
    }

}
