package com.gogirl.interfaces.product.serve;

import com.gogirl.application.product.serve.BaseFeaturesService;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.product.ProduceFeaturesDTO;
import com.gogirl.shared.product.ServeFeaturesDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@AllArgsConstructor
@Api("首页标签接口")
public class BaseFeaturesController {

    private final BaseFeaturesService baseFeaturesService;

    @ApiOperation("查询首页服务标签")
    @GetMapping("/customer/label/no_queryServeLabel")
    public JsonResult<List<ServeFeaturesDTO>> queryServeFeatures(@RequestParam(required = false) Integer typeId,
                                                                 @RequestHeader("brandId") Integer brandId) {
        List<ServeFeaturesDTO> serveFeaturesDTOList = baseFeaturesService.queryServeFeatures(typeId, brandId);
        return JsonResult.success(serveFeaturesDTOList);
    }


    @ApiOperation("查询首页款式标签")
    @GetMapping("/customer/label/no_queryProduceLabel")
    public JsonResult<List<ProduceFeaturesDTO>> queryProduceFeatures(@RequestParam(required = false) Integer serveTypeId,
                                                                     @RequestHeader("brandId") Integer brandId) {
        List<ProduceFeaturesDTO> produceFeaturesDTOList = baseFeaturesService.queryProduceFeatures(serveTypeId, brandId);
        return JsonResult.success(produceFeaturesDTOList);
    }

}
