package com.gogirl.interfaces.common;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.common.xcx.impl.MiniappBrandConfigService;
import com.gogirl.domain.common.xcx.MiniappBrandConfig;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.config.config.WxPayConfig;
import com.gogirl.shared.user.ReadMessageCommand;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.web.JsonPath;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.websocket.server.PathParam;
import java.lang.reflect.Field;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-12
 * @Modified by:
 */
@RestController
@AllArgsConstructor
@Api(tags = {"小程序配置"})
@Slf4j
public class MiniappBrandConfigController {

    @Resource
    private MiniappBrandConfigService miniappBrandConfigService;

    @Deprecated
    @ApiOperation("获取小程序模板，不建议使用")
    @GetMapping(value = {"/customer/miniapp/brand/config/tpl","/technician/miniapp/brand/config/tpl"})
    public JsonResult<MiniappBrandConfig> tpl(@RequestHeader("brandId") Integer brandId) {
        MiniappBrandConfig config = WxPayConfig.brandMap.get(brandId);
        return JsonResult.success(config);
    }

    @ApiOperation("获取小程序模板")
    @GetMapping(value = {"/customer/miniapp/brand/configuration/tpl","/technician/miniapp/brand/configuration/tpl"})
    public JsonResult<MiniappBrandConfig> tpl(@RequestParam String appId) {
        MiniappBrandConfig config = miniappBrandConfigService.getOne(
                new LambdaQueryWrapper<MiniappBrandConfig>()
                        .eq(MiniappBrandConfig::getStoreMiniappId,appId)
        );
        return JsonResult.success(config);
    }
}
