package com.gogirl.infrastructure.common.util.lock;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

/**
 *  * 分段锁，系统提供一定数量的原始锁，根据传入用户id值获取对应的锁并加锁  * 注意：要锁的用户id值如果发生改变，有可能导致锁无法成功释放!!!
 */
public class MallOrderIdLock {
    private final static HashMap<Long, ReentrantLock> lockMap = new HashMap<>();
    private long segments = 1;// 默认分段数量

    private MallOrderIdLock() {
        init(null, false);
    }

    private MallOrderIdLock(Integer counts, boolean fair) {
        init(counts, fair);
    }

    /*静态内部类实现单例*/
    public static MallOrderIdLock getInstance() {
        return SingletonHolder.instance;
    }

    private void init(Integer counts, boolean fair) {
        if (counts != null) {
            segments = counts;
        }
        for (long i = 0; i < segments; i++) {
            lockMap.put(i, new ReentrantLock(fair));
        }
    }

    public void lock(long key) {
        ReentrantLock lock = lockMap.get(key % segments);
        lock.lock();
    }

    public void unlock(long key) {
        ReentrantLock lock = lockMap.get(key % segments);
        lock.unlock();
    }

    @Override
    public String toString() {
        return "SegmentLock [segments=" + segments + ", lockMap=" + lockMap
                + "]";
    }

    /*静态内部类实现单例*/
    private static class SingletonHolder {
        private static final MallOrderIdLock instance = new MallOrderIdLock(null, true);
    }

}
