package com.gogirl.domain.user.investigation;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 订单问卷调查
 * </p>
 *
 * @author luobin
 * @since 2019-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OrderQuestionOption对象", description = "订单问卷调查")
@TableName("order_question_option")
public class OrderQuestionOption implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("问题id")
    private Integer questionId;

    @ApiModelProperty("问题选项id")
    private Integer questionOptionId;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("订单id")
    private Integer orderId;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("")
    private Integer testPaperCustomerMapId;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    /**
     * 冗余
     */
    @ApiModelProperty("投诉设计的sku类型 1-店务 2-接待")
    @TableField(exist = false)
    private Integer complaintType;

    @ApiModelProperty("投诉涉及的Sku")
    @TableField(exist = false)
    private Integer complaintSkuId;


}
