package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 款式的 技法映射
 * </p>
 *
 * @author robbendev
 * @since 2020-05-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="OwnProduceTechniqueSku对象", description="款式的 技法映射")
public class OwnProduceTechniqueSku implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "base_produce.id")
    private Integer ownProduceId;

    @ApiModelProperty(value = "technique_sku.id")
    private Integer techniqueSkuId;

    @ApiModelProperty(value = "数量")
    private BigDecimal quantity;

    @TableField(exist = false)
    private Integer duration;

    @ApiModelProperty("品牌ID")
    private Integer brandId;
    
}
