package com.gogirl.domain.common;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @Author: li.yanlin
 * @Description：
 * @Date: Created in  2021-05-13
 * @Modified by:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="腾讯云短信配置", description="")
public class SmsConfig {
    // 短信应用SDK AppID
    @ApiModelProperty(value = "短信应用SDK AppID")
    private Integer appId;

    // 短信应用SDK AppKey
    @ApiModelProperty(value = "短信应用SDK AppKey")
    private String appKey;

    // 短信模板ID，需要在短信应用中申请
    @ApiModelProperty(value = "短信模板ID，需要在短信应用中申请")
    private Integer bindTemplateId;

    // 腾讯云短信签名
    @ApiModelProperty(value = "腾讯云短信签名")
    private String smsSign;

    //验证码有效时间
    @ApiModelProperty(value = "验证码有效时间")
    private String activeTime;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;

    private LocalDateTime createTime;

    private LocalDateTime lastUpdateTime;
}
