package com.gogirl.application.user.investigation.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.market.coupon.ICouponsGiftService;
import com.gogirl.application.store.complaint.ComplaintMainService;
import com.gogirl.application.user.investigation.BaseQuestionService;
import com.gogirl.application.user.investigation.OrderQuestionOptionService;
import com.gogirl.application.user.investigation.TestPaperQuestionService;
import com.gogirl.domain.market.coupon.CouponsGift;
import com.gogirl.domain.user.investigation.*;
import com.gogirl.infrastructure.mapper.user.investigation.BaseQuestionMapper;
import com.gogirl.infrastructure.mapper.user.investigation.TestPaperCustomerMapMapper;
import com.gogirl.infrastructure.mapper.user.investigation.TestPaperMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class BaseQuestionServiceImpl extends ServiceImpl<BaseQuestionMapper, BaseQuestion> implements BaseQuestionService {

    @Resource
    private BaseQuestionMapper baseQuestionMapper;
    @Resource
    private TestPaperMapper testPaperMapper;
    @Resource
    private TestPaperCustomerMapMapper testPaperCustomerMapMapper;
    @Resource
    private TestPaperQuestionService testPaperQuestionService;
    @Resource
    private OrderQuestionOptionService orderQuestionOptionService;
    @Resource
    private ComplaintMainService complaintMainService;

    @Resource
    private CouponService couponService;

    @Override
    public List<BaseQuestion> getTestPaper(Integer currentCustomerId, Integer brandId) {
        return baseQuestionMapper.getTestPaper(currentCustomerId, brandId);
    }

    @Override
    public void submitTestPaper(Integer currentCustomerId, Integer brandId, List<OrderQuestionOption> list) {
        TestPaper testPaper = new TestPaper();
        testPaper.setCreateDate(new Date());
        testPaper.setCreateUser(currentCustomerId);
        testPaper.setName("问卷调查");
        testPaper.setBrandId(brandId);
        testPaperMapper.insert(testPaper);

        TestPaperCustomerMap testPaperCustomerMap = new TestPaperCustomerMap();
        testPaperCustomerMap.setCreateDate(new Date());
        testPaperCustomerMap.setCustomerId(currentCustomerId);
        testPaperCustomerMap.setTestPaperId(testPaper.getId());
        testPaperCustomerMap.setBrandId(brandId);
        testPaperCustomerMapMapper.insert(testPaperCustomerMap);


        List<TestPaperQuestion> testPaperQuestionList = list.stream()
                .map(orderQuestionOption -> {
                    TestPaperQuestion testPaperQuestion = new TestPaperQuestion();
                    testPaperQuestion.setQuestionId(orderQuestionOption.getQuestionId());
                    testPaperQuestion.setTestPaperId(testPaper.getId());
                    testPaperQuestion.setBrandId(brandId);
                    return testPaperQuestion;
                })
                .collect(Collectors.toList());
        testPaperQuestionService.saveBatch(testPaperQuestionList);


        list.forEach(orderQuestionOption -> {
            orderQuestionOption.setCustomerId(currentCustomerId);
            orderQuestionOption.setTestPaperCustomerMapId(testPaperCustomerMap.getId());
            orderQuestionOption.setCreateTime(new Date());

        });
        orderQuestionOptionService.saveBatch(list);

        complaintMainService.saveComplainsByOrderQuestion(list);


        couponsGiftService.sendGift(currentCustomerId, CouponsGift.BEHAVIOR_SURVEY, null);
    }

    @Resource
    ICouponsGiftService couponsGiftService;

}
