package com.gogirl.application.order.pay.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.pay.IOrderPayService;
import com.gogirl.domain.order.pay.OrderPay;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.order.pay.OrderPayMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 订单支付明细 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@Service
@Slf4j
public class OrderPayServiceImpl extends ServiceImpl<OrderPayMapper, OrderPay> implements IOrderPayService {

    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    OrderPayMapper orderPayMapper;

    @Override
    public void recordOrderPay(Integer orderId) {

        OrderManage orderManage = orderManageMapper.selectById(orderId);

        if (orderManage.getPaymentType().equals(1)) {
            OrderPay orderPay = new OrderPay();
            orderPay.setAmount(orderManage.getTotalPaymentAmount());
            orderPay.setOrderId(orderManage.getId());
            orderPay.setType(1);
            orderPayMapper.insert(orderPay);
        }
        if (orderManage.getPaymentType().equals(2)) {
            OrderPay orderPay = new OrderPay();
            orderPay.setAmount(orderManage.getTotalPaymentAmount());
            orderPay.setOrderId(orderManage.getId());
            orderPay.setType(2);
            orderPayMapper.insert(orderPay);
        }
        if (orderManage.getPaymentType().equals(5)) {
            OrderPay orderPay = new OrderPay();
            orderPay.setAmount(orderManage.getTotalPaymentAmount());
            orderPay.setOrderId(orderManage.getId());
            orderPay.setType(5);
            orderPayMapper.insert(orderPay);
        }

        if (orderManage.getPaymentType().equals(12) || orderManage.getPaymentType().equals(13)) {

            try {
                List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
                multiPaymentTypeList.forEach(multiPaymentType -> {
                    if (multiPaymentType.getType().equals(1)) {
                        OrderPay orderPay = new OrderPay();
                        orderPay.setAmount(multiPaymentType.getPrice());
                        orderPay.setOrderId(orderManage.getId());
                        orderPay.setType(1);
                        orderPayMapper.insert(orderPay);
                    }
                    if (multiPaymentType.getType().equals(2)) {
                        OrderPay orderPay = new OrderPay();
                        orderPay.setAmount(multiPaymentType.getPrice());
                        orderPay.setOrderId(orderManage.getId());
                        orderPay.setType(2);
                        orderPayMapper.insert(orderPay);
                    }

                    if (multiPaymentType.getType().equals(5)) {
                        OrderPay orderPay = new OrderPay();
                        orderPay.setAmount(multiPaymentType.getPrice());
                        orderPay.setOrderId(orderManage.getId());
                        orderPay.setType(5);
                        orderPayMapper.insert(orderPay);
                    }
                });
            } catch (Exception e) {
                log.error("orderId:no multi :{}", orderManage.getId());
            }
        }
    }
}
