package com.gogirl.domain.market.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@Api("次卡的开卡记录和使用记录")
@Data
@TableName("times_card_used_record")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TimesCardUsedRecord {

    public static Integer STATUS_CHOSE = 1;
    public static Integer STATUS_USED = 2;
    @TableId(type = IdType.AUTO)
    private Integer id;
    private Integer cardTypeId;
    private Integer customerId;
    private Integer cardRelevanceCustomerId;
    @ApiModelProperty("生成记录时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;
    @ApiModelProperty("1.购卡记录;2;用卡记录")
    private Integer type;
    @ApiModelProperty("订单id")
    private Integer orderId;
    @ApiModelProperty("美甲服务id")
    private Integer serveId;
    @ApiModelProperty("订单服务的id")
    private Integer orderServeId;
    @ApiModelProperty("美甲师id,store_technician表id")
    private Integer technicianId;
    @ApiModelProperty("店铺id")
    private Integer departmentId;
    private String serveName;
    private String technicianName;
    private String departmentName;
    @ApiModelProperty("1.已选择次卡,待付款;2.已使用;3.已取消选择")
    private Integer status;
    private String name;
    private BigDecimal discountAmount;
    private BigDecimal payAmount;
    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    private TimesCardType timesCardType;
    @TableField(exist = false)
    private TimesCardCustomerRelevance timesCardCustomerRelevance;

}
