package com.gogirl.application.store.store.impl;


import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.infrastructure.mapper.store.StoreClassesTechnicianMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by yinyong on 2018/9/20.
 */
@Service
@AllArgsConstructor
public class StoreClassesTechnicianServiceImpl implements StoreClassesTechnicianService {

    private final StoreClassesTechnicianMapper storeClassesTechnicianMapper;

    @Override
    public List<StoreClassesTechnician> listClassesTechnician(Integer scheduledId, Integer departmentId, String days) {
        List<StoreClassesTechnician> storeClassesTechnicianList = storeClassesTechnicianMapper.listClassesTechnician(scheduledId, departmentId, days);

        return storeClassesTechnicianList;
    }

    @Override
    public List<StoreClassesTechnician> listClassesTechnicianDetail(Integer userId, String days) {
        List<StoreClassesTechnician> storeClassesTechnicianList = storeClassesTechnicianMapper.listClassesTechnicianDetail(userId, days);
        return storeClassesTechnicianList;
    }

    @Override
    public List<StoreClassesTechnician> listClassesTechnicianDetailByDays(Integer userId, String days) {
        List<StoreClassesTechnician> storeClassesTechnicianList = storeClassesTechnicianMapper.listClassesTechnicianDetailByDays(userId, days);
        return storeClassesTechnicianList;
    }

    @Override
    public List<StoreClassesTechnician> getReservableTime(String startDate, String startTime, Integer departmentId) {
        List<StoreClassesTechnician> listClassesManage = storeClassesTechnicianMapper.listClassTimeByStartDate(startDate, startTime, departmentId);
        return listClassesManage;
    }

    @Override
    @Transactional(timeout = 10000)
    public void updateClassesTechnician(StoreClassesTechnician storeClassesTechnician) {
        storeClassesTechnicianMapper.updateClassesTechnician(storeClassesTechnician);
    }

    @Override
    @Transactional(timeout = 10000)
    public void insertClassesTechnician(StoreClassesTechnician storeClassesTechnician) {
        storeClassesTechnicianMapper.insertClassesTechnician(storeClassesTechnician);
    }


}
