package com.gogirl.infrastructure.feign;

import com.gogirl.shared.admin.AdminPage;
import com.gogirl.shared.admin.AdminResult;
import com.gogirl.shared.admin.dashboard.req.*;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResult;
import com.gogirl.shared.admin.techcnian.AchievementsPersonaResultPageApiRequest;
import com.gogirl.shared.admin.techcnian.AdminTechnicianScoreResp;
import com.gogirl.shared.admin.techcnian.GetTechnicianPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 管理后台接口
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:11 上午
 */
@FeignClient(url = "http://admin.begogirls.com:7712", value = "adminFeign", fallback = AdminFeign.AdminFeignFallback.class)
public interface AdminFeign {

    @PostMapping(value = "/api/ReportTable/GetStoreTrendApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<GetStoreTrendApiResp> getStoreTrendApi(@RequestBody GetStoreTrendApiRequest request);

    @PostMapping(value = "/api/ReportTable/GetStoreListApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<List<Map<String, Object>>> getStoreListApi(@RequestBody GetStoreListApiRequest request);


    @PostMapping(value = "/api/Report/PreStorageSumApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<Map<String, Object>> preStorageSumApi(@RequestBody PreStorageSumApiRequest request);

    @PostMapping(value = "/api/Report/RevenueSumByTypeApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<Map<String, Object>> revenueSumByTypeApi(@RequestBody RevenueSumByTypeApiRequest request);

    @PostMapping(value = "/api/Report/RevenueTypeListApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<List<Map<String, Object>>> revenueTypeListApi(@RequestBody RevenueTypeListRequest request);

    @PostMapping(value = "/api/Report/RevenueSumApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<List<Map<String, Object>>> revenueSumApi(@RequestBody RevenueSumApiRequest request);


    @PostMapping(value = "/api/ReportTable/GetTechnicianPage",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<AdminPage<AdminTechnicianScoreResp>> getTechnicianPage(@RequestBody GetTechnicianPageRequest request);

    @PostMapping(value = "/api/salary/AchievementsPersonaResultPageApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<AdminPage<AchievementsPersonaResult>> achievementsPersonaResultPageApi(@RequestBody AchievementsPersonaResultPageApiRequest request);

    @PostMapping(value = "/api/Report/RevenueServiceListApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<List<Map<String, Object>>> revenueServiceListApi(@RequestBody RevenueServiceListApiRequest request);

    @Component
    class AdminFeignFallback implements AdminFeign {


        @Override
        public AdminResult<GetStoreTrendApiResp> getStoreTrendApi(GetStoreTrendApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<List<Map<String, Object>>> getStoreListApi(GetStoreListApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<Map<String, Object>> preStorageSumApi(PreStorageSumApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<Map<String, Object>> revenueSumByTypeApi(RevenueSumByTypeApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<List<Map<String, Object>>> revenueTypeListApi(RevenueTypeListRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<List<Map<String, Object>>> revenueSumApi(RevenueSumApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<AdminPage<AdminTechnicianScoreResp>> getTechnicianPage(GetTechnicianPageRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<AdminPage<AchievementsPersonaResult>> achievementsPersonaResultPageApi(AchievementsPersonaResultPageApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<List<Map<String, Object>>> revenueServiceListApi(RevenueServiceListApiRequest request) {
            return new AdminResult<>();
        }
    }
}
