package com.gogirl.infrastructure.service.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.infrastructure.mapper.product.mall.MallProductMapper;
import com.gogirl.shared.product.excel.ImportMallProductExcel;
import com.gogirl.shared.product.excel.ImportPurchaseSkuExcel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/6/12 5:54 下午
 */
public class MallProductExcelListener extends AnalysisEventListener<ImportMallProductExcel> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ImportPurchaseSkuExcel.class);
    private final MallProductMapper mallProductMapper;
    /**
     * 每隔5条存储数据库，实际使用中可以3000条，然后清理list ，方便内存回收
     */
    private static final int BATCH_COUNT = 5;

    List<ImportMallProductExcel> list = new ArrayList<>();

    public MallProductExcelListener(MallProductMapper mallProductMapper) {
        this.mallProductMapper = mallProductMapper;
    }

    @Override
    public void invoke(ImportMallProductExcel data, AnalysisContext context) {
        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        LOGGER.info("所有数据解析完成！");
    }

    /**
     * 加上存储数据库
     */
    private void syncData() {
        LOGGER.info("{}条数据，开始存储数据库！", list.size());
        list.forEach(importMallProductExcel -> {

            MallProduct mallProduct = mallProductMapper.selectOne(new LambdaQueryWrapper<MallProduct>()
                    .eq(MallProduct::getProdSysCode, importMallProductExcel.getProdSysCode()));

            mallProduct.setPrice(importMallProductExcel.getPrice());
            mallProduct.setBargainPrice(importMallProductExcel.getBargainPrice());
            mallProductMapper.updateById(mallProduct);
        });
        LOGGER.info("存储数据库成功！");
    }
}
