package com.gogirl.application.order.mall;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.order.mall.MallOrderTechnician;
import com.gogirl.shared.order.mall.QueryMallOrderAchievementRequest;

import java.math.BigDecimal;

/**
 * <p>
 * 商城订单  - 美甲师 服务类
 * </p>
 *
 * @author robbendev
 * @since 2020-06-22
 */
public interface IMallOrderTechnicianService extends IService<MallOrderTechnician> {

    /**
     * 查询美甲师商城业绩列表
     *
     * @param request
     * @return
     */
    Page<MallOrderTechnician> queryMallOrderAchievement(QueryMallOrderAchievementRequest request);

    /**
     * 查询总业绩
     * @param technicianId
     * @param departmentId
     * @param date
     * @return
     */
    BigDecimal queryTotalMallOrderAchievement(Integer technicianId, Integer departmentId, String date);
}
