package com.gogirl.infrastructure.common.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.product.purchase.PurchaseSku;
import com.gogirl.infrastructure.mapper.product.purchase.PurchaseSkuMapper;
import com.gogirl.shared.order.ImportPurchaseSkuExcel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 有个很重要的点 DemoDataListener 不能被spring管理，要每次读取excel都要new,然后里面用到spring可以构造方法传进去
 * </p>
 *
 * @author robbendev
 * @since 2020/6/6 5:29 下午
 */
public class ExcelListener extends AnalysisEventListener<ImportPurchaseSkuExcel> {

    private static final Logger LOGGER = LoggerFactory.getLogger(ImportPurchaseSkuExcel.class);
    private final PurchaseSkuMapper purchaseSkuMapper;
    /**
     * 每隔5条存储数据库，实际使用中可以3000条，然后清理list ，方便内存回收
     */
    private static final int BATCH_COUNT = 5;

    List<ImportPurchaseSkuExcel> list = new ArrayList<>();

    public ExcelListener(PurchaseSkuMapper purchaseSkuMapper) {
        this.purchaseSkuMapper = purchaseSkuMapper;
    }

    @Override
    public void invoke(ImportPurchaseSkuExcel data, AnalysisContext context) {
        LOGGER.info("解析到一条数据:{}", JSON.toJSONString(data));
        list.add(data);
        if (list.size() >= BATCH_COUNT) {
            syncData();
            list.clear();
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        syncData();
        LOGGER.info("所有数据解析完成！");
    }

    /**
     * 加上存储数据库
     */
    private void syncData() {
        LOGGER.info("{}条数据，开始存储数据库！", list.size());
        list.forEach(importPurchaseSkuExcel -> {
            if (importPurchaseSkuExcel.getPurchasePrice() == null && StringUtils.isNotEmpty(importPurchaseSkuExcel.getSku())) {
                purchaseSkuMapper.delete(new LambdaQueryWrapper<PurchaseSku>().eq(PurchaseSku::getSku, importPurchaseSkuExcel.getSku()));
            }
            PurchaseSku purchaseSku = purchaseSkuMapper.selectBySku(importPurchaseSkuExcel.getSku());
            if (purchaseSku != null) {
                purchaseSku.setShopPrice(importPurchaseSkuExcel.getShopPrice());
                purchaseSku.setPurchasePrice(importPurchaseSkuExcel.getPurchasePrice());
                purchaseSkuMapper.updateById(purchaseSku);
            }

        });
        LOGGER.info("存储数据库成功！");
    }
}