package com.gogirl.infrastructure.common.filter;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.gogirl.infrastructure.common.util.JsonUtilByJackson;
import com.gogirl.infrastructure.common.wrapper.RequestBakRequestWrapper;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 日志traceId
 *
 * @author robbendev
 */
@Component
@ServletComponentScan
@WebFilter(urlPatterns = {"/customer/*", "/technician/*"}, filterName = "requestLogFilter")
@Slf4j
public class RequestLogFilter implements Filter {

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {

    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String traceId = IdWorker.getIdStr();
        request.setAttribute("traceId", traceId);
        MDC.put("traceId", traceId);
        if ((request instanceof HttpServletRequest) && (response instanceof HttpServletResponse)) {
            RequestBakRequestWrapper bakRequestWrapper = (RequestBakRequestWrapper) request;
            log.info("uri:{}", bakRequestWrapper.getRequestURI());
            log.info("param:{}", JsonUtilByJackson.writeValueAsString(bakRequestWrapper.getParameterMap()));
            log.info("payload:{}", bakRequestWrapper.getCachedContent().toString());
        }

        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        MDC.clear();
    }
}
