package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
@AllArgsConstructor
public class BaseServeServiceImpl extends ServiceImpl<BaseServeMapper, BaseServe> implements BaseServeService {

    private final BaseServeMapper baseServeMapper;


    @Override
    public IPage<BaseServe> listServeForPage(IPage<BaseServe> page, BaseServe param) {
        return baseServeMapper.listServeForPage(page, param);
    }


    @Override
    public BaseServe getAggregate(Integer id, LocalDateTime date, Integer departmentId) {
        return baseServeMapper.selectById(id);
    }
}
