package com.gogirl.shared.order.serve.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.shared.product.query.dto.PurchaseSkuDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * Created by yinyong on 2018/10/7.
 */

@ApiModel("预约服务关联")
@Data
public class ScheduleServeDTO implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private Integer id;

    @ApiModelProperty("预约id")
    private Integer schId;

    @ApiModelProperty("预约美甲师id")
    private Integer technicianId;


    @ApiModelProperty("预约美甲师姓名")
    private String technicianName;

    @ApiModelProperty("预约美甲师id")
    private String technicianIds;

    private String technicianNames;

    @ApiModelProperty("主服务id")
    private Integer mainServeId;

    @ApiModelProperty("0系统分配美甲师.1.客户指定美甲师")
    private Boolean isCustomerPick = false;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("服务时长")
    private Integer lengthTime;

    /**
     * 预约服务vo
     */
    @ApiModelProperty("预约服务id")
    private Integer serveId;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("图片名称")
    private String servePicturePath;

    @ApiModelProperty("服务价格")
    private BigDecimal servePrice;

    @ApiModelProperty("服务数量")
    private Integer serveNumber;

    private BigDecimal discountRate;

    /**
     * 预约款式vo
     */
    @ApiModelProperty("款式名称")
    private String produceName;

    @ApiModelProperty("款式图片地址")
    private String producePicturePath;

    @ApiModelProperty("款式当前价格")
    private BigDecimal produceCurrentPrice;

    @ApiModelProperty("款式特价")
    private BigDecimal produceBargainPrice;

    @ApiModelProperty("预约款式id")
    private Integer produceId;

    @ApiModelProperty("创建用户")
    private String createUser;

    @ApiModelProperty("售后说明")
    private String explain;

    private Integer status;

    @ApiModelProperty("实际开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualStartTime;

    @ApiModelProperty("实际结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date actualEndTime;

    private Integer leisureDiscountConfigId;

    private List<PurchaseSkuDTO> purchaseSkuDTOList;

    private Integer actualServeDuration;


    private BigDecimal promotionPrice;

    private Integer producePromotionTimeId;

    private BigDecimal leisurePrice;

    @ApiModelProperty("服务价格")
    private BigDecimal price = BigDecimal.ZERO;

}
