package com.gogirl.application.product.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.product.mall.MallShoppingCartQryService;
import com.gogirl.assembler.MallShoppingCartDTOAssembler;
import com.gogirl.domain.order.mall.MallShoppingCart;
import com.gogirl.domain.product.mall.MallProduct;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.order.mall.MallShoppingCartMapper;
import com.gogirl.infrastructure.mapper.product.mall.MallProductMapper;
import com.gogirl.shared.product.query.dto.MallShoppingCartDTO;
import com.gogirl.shared.product.query.dto.MyMallShoppingCartDTO;
import com.gogirl.shared.product.query.qry.MyShoppingCartQuery;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
public class MallShoppingCartQryServiceImpl implements MallShoppingCartQryService {

    private final MallShoppingCartMapper mallShoppingCartMapper;
    private final MallShoppingCartDTOAssembler mallShoppingCartDTOAssembler;
    private final MallProductMapper mallProductMapper;

    @Override
    public MyMallShoppingCartDTO queryMyShoppingCart(MyShoppingCartQuery qry) {
        List<MallShoppingCart> mallShoppingCartList = mallShoppingCartMapper.selectList(
                new LambdaQueryWrapper<MallShoppingCart>().eq(MallShoppingCart::getCustomerId, qry.getCustomerId())
        );
        List<Long> productIds = mallShoppingCartList.stream().map(MallShoppingCart::getProductId)
                .collect(Collectors.toList());
        if (ListUtil.isNotEmpty(productIds)) {
            Map<Long, List<MallProduct>> map = mallProductMapper.selectBatchIds(productIds)
                    .stream()
                    .collect(Collectors.groupingBy(MallProduct::getId));
            mallShoppingCartList.forEach(mallShoppingCart -> {
                List<MallProduct> mallProductList = map.get(mallShoppingCart.getProductId());
                if (ListUtil.isNotEmpty(mallProductList)) {
                    mallShoppingCart.setMallProduct(mallProductList.stream().findAny().orElse(null));
                }
            });
        }

        List<MallShoppingCartDTO> mallShoppingCartDTOList = mallShoppingCartList.stream().map(mallShoppingCartDTOAssembler).collect(Collectors.toList());
        MyMallShoppingCartDTO data = new MyMallShoppingCartDTO();

        data.setMallShoppingCartDTOList(mallShoppingCartDTOList);

        data.setItemSum(mallShoppingCartList.stream()
                .map(MallShoppingCart::getNum)
                .mapToInt(Integer::intValue)
                .sum());
        return data;
    }
}
