package com.gogirl.domain.common;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="AgentUserBalanceLog对象", description="")
public class AgentUserBalanceLog implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer agentUserId;

    @ApiModelProperty(value = "金额 （扣款用负数表示）")
    private BigDecimal amount;

    @ApiModelProperty(value = "1 = 充值余额 2 = 商城订单扣余额  3 = 充保证金 4 = 商城订单扣保证金")
    private Integer type;

    @ApiModelProperty(value = "时间")
    private LocalDateTime date;

    @ApiModelProperty(value = "创建人")
    private String createUser;

    @ApiModelProperty(value = "余额")
    private BigDecimal balance;

    @ApiModelProperty(value = "保证金")
    private BigDecimal bondAmountBalance;

    @ApiModelProperty(value = "折扣")
    private BigDecimal discount;

    @ApiModelProperty(value = "品牌id")
    private Integer brandId;

    @ApiModelProperty(value = "备注")
    private String remarks;

    private String orderId;

    public static AgentUserBalanceLog getInstance(AgentUser agentUser){
        AgentUserBalanceLog agentUserBalanceLog = new AgentUserBalanceLog();

        agentUserBalanceLog.setAgentUserId(agentUser.getId());
        agentUserBalanceLog.setBalance(agentUser.getBalance());
        agentUserBalanceLog.setBondAmountBalance(agentUser.getBondAmount());
        agentUserBalanceLog.setDiscount(agentUser.getDiscount());
        return agentUserBalanceLog;
    }

}
