package com.gogirl.shared.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 时间段类
 */
@Data
public class Period implements Serializable {

    private Long startTime;
    private Long endTime;
    private Long length;

    public Period(Long startTime, Long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.length = endTime - startTime;
    }

    public Period(Date startTime, Date endTime) {
        this.startTime = startTime.getTime();
        this.endTime = endTime.getTime();
        this.length = this.endTime - this.startTime;
    }

    public Period() {
    }

    public boolean in(Period period) {

        return period.getEndTime() >= endTime
                && period.getStartTime() <= startTime;
    }
    public boolean in(long datetime) {

        return datetime >= startTime
                && datetime <= endTime;
    }

    public boolean notIn(Period period) {
        return !in(period);
    }

    public boolean notIn(long datetime) {
        return !in(datetime);
    }


    public boolean conflict(Period period) {

        return (startTime < period.getEndTime() && startTime > period.getStartTime())
                || (endTime < period.getEndTime() && endTime > period.getStartTime())
                || period.in(this);
    }
}
