package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.sql.Time;
import java.util.Date;
import java.util.List;

/**
 * Created by yinyong on 2018/9/17.
 */
@ApiModel("店铺管理")
@Data
@TableName("store_manage")
public class StoreManage implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("店铺编号")
    private String storeNo;

    @ApiModelProperty("logo")
    private String logo;

    @ApiModelProperty("店铺名称")
    private String name;

    @ApiModelProperty("店铺英文名")
    private String enName;

    @ApiModelProperty("纬度")
    private String longitude;

    @ApiModelProperty("精度")
    private String latitude;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("店长")
    private String master;

    @ApiModelProperty("员工数量")
    private Integer employeeNumber;

    @ApiModelProperty("客户电话号码")
    private String customerServiceTelphone;

    @ApiModelProperty("联系人名称")
    private String contactName;

    @ApiModelProperty("联系人电话")
    private String contactTelphone;

    @ApiModelProperty("店铺简介")
    private String remark;

    @ApiModelProperty("营业周天")
    private Integer businessDay;

    @ApiModelProperty("营业开始时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time businessStartTime;

    @ApiModelProperty("营业结束时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time businessEndTime;

    @TableField(exist = false)
    private Double distance;

    @ApiModelProperty("店照")
    private String shopEnvironmentPhotos;

    @ApiModelProperty("店铺短码")
    private String shortCode;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("店长id")
    private Integer masterUserId;

    @ApiModelProperty("营业状态1.营业中;2.停止营业")
    private Integer operatingStatus;

    @ApiModelProperty("运营人员id")
    private Integer operateUserId;

    @TableField(exist = false)
    private List<StoreGuide> storeGuideDTOList;

    private String shortAddress;

}
