package com.gogirl.application.order.sys.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.sys.IWxOrderFlowService;
import com.gogirl.domain.order.sys.WxOrderFlow;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.order.sys.WxOrderFlowMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 微信订单流水 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-23
 */
@Slf4j
@Service
public class WxOrderFlowServiceImpl extends ServiceImpl<WxOrderFlowMapper, WxOrderFlow> implements IWxOrderFlowService {

    @Async
    @Override
    public void log(WxOrderFlow wxOrderFlow) {
        log.info("保存微信订单流水:{}", JsonUtilByFsJson.beanToJson(wxOrderFlow));
        this.save(wxOrderFlow);
    }
}
