# gogirl小程序后端

## 如何使用

swagger: http://134.175.167.230:5555/doc.html

## 项目结构

```

└── com
    └── gogirl
        ├── GogirlMiniappApplication.java
        ├── application
        │   ├── common      //通用服务
        │   ├── customer    //用户服务
        │   ├── dashboard   //店员看板服务
        │   ├── market      //营销服务
        │   ├── order       //订单服务
        │   ├── product     //产品服务
        │   ├── store       //店铺服务
        │   └── user        //用户服务（旧）
        ├── assembler       //转换器
        ├── domain          //实体领域层
        ├── infrastructure  //基础设施层
        │   ├── common      //应用通用组件配置
        │   ├── feign       //三方api调用
        │   ├── mapper      //数据库mapper
        │   ├── schedule    //应用定时任务
        │   └── service     //基础服务
        ├── interfaces      //REST API
        └── shared          //dto
```



## 如何开发

### 代码生成器
test/java/com/gogirl/CodeGenerator

### controller
```java
@Api(tags = "商城收货地址接口")
@RestController
@AllArgsConstructor
public class MallCustomerAddressController {

    private final MallCustomerAddressService mallCustomerAddressService;

    @ApiOperation("新增收货地址")
    @PostMapping("/customer/customerAddress/addMallCustomerAddress")
    public JsonResult<MallCustomerAddress> addMallCustomerAddress(@RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_FALSE);
        mallCustomerAddressService.addMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }
}
```

#### service
```java
public interface MallCustomerAddressService extends IService<MallCustomerAddress> {

    /**
     * 新增收货地址
     *
     * @param mallCustomerAddress 收货地址
     */
    void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress);
}

@Service
public class MallCustomerAddressServiceImpl extends ServiceImpl<MallCustomerAddressMapper, MallCustomerAddress> implements MallCustomerAddressService {

    @Override
    public void addMallCustomerAddress(MallCustomerAddress mallCustomerAddress) {
        this.save(mallCustomerAddress);
    }
}
```

#### mapper
```java
public interface MallCustomerAddressMapper extends BaseMapper<MallCustomerAddress> {
}

```

### 发布
1.提交代码
```
git commit push
``` 

2.登陆发布服务器
```
ssh root@http://134.175.167.230/
```

3.发布测试环境
```
sh /deploy-miniapp-pre.sh
``` 
> 注意修改测试分支

4.发布正式环境
```
sh /deploy-miniapp-prod.sh
```

## 其他

### 常用实体（表）
```

├── market //营销模块
│   ├── coupon
│   │   ├── Coupon.java //卡券配置主表
│   │   ├── CouponCustomerRelevance.java //卡券实体表
│   ├── discount
│   │   ├── DiscountConfig.java //充值配置
│   │   └── VipServe.java //会员福利配置
│   └── timescard
│       ├── TimesCardCustomerRelevance.java //次卡实体表
│       ├── TimesCardType.java //次卡配置
│       └── TimesCardUsedRecord.java //次卡使用记录
├── order //订单服务
│   ├── serve
│   │   ├── OrderManage.java //订单字表
│   │   ├── OrderServe.java //订单详情表
│   │   ├── ScheduleManage.java //预约主表
│   │   ├── ScheduleServe.java //预约
├── product //产品服务
│   ├── mall
│   │   ├── MallCategory.java //商城商品分类
│   │   └── MallProduct.java //商城商品主表
│   ├── purchase
│   │   ├── PurchaseSku.java //采购sku主表
│   └── serve
│       ├── BaseProduce.java //服务款式主表
│       ├── BaseServe.java //服务主表
│       ├── BaseType.java //服务类型
├── store //店铺模块
│   ├── oa
│   │   ├── OverTimeRecord.java //加班记录主表
│   │   ├── OverTimeRecordLog.java //加班记录使用详情
│   │   └── TakeLeaveEvent.java //请假主表
│   ├── store
│   │   ├── StoreManage.java //店铺主表
│   │   ├── StoreTechnician.java //美甲师（店员主表）
└── user //用户模块
    ├── customer
    │   ├── Customer.java //用户主表
    │   ├── CustomerBalance.java //用户会员卡
    │   ├── CustomerBalanceRecord.java //用户会员卡记录
    │   ├── CustomerDetail.java //用户从表
```

### 撤回订单（待付款 -> 待核算）
```java
/**
 * {@link CustomerBalanceServiceImplTest#order()}
 */
```
如果订单已经支付了，要先改订单状态到待支付。会员支付的需要改会员流水。其他支付方式找店员核实是否真的支付了还是点错了。

### 充值充错了
```sql
-- 查用户
SELECT * from customer where phone = 13423646656;
-- 删除充值记录
SELECT * from customer_balance_record where customer_id = 28797;
- 修改会员余额
SELECT * from customer_balance where customer_id = 28797;

```

### 会员福利约不了？
看`customer_balance`的level字段 和`vip_serve`配置
