package com.gogirl.interfaces.store.oa;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.application.store.oa.IOverTimeRecordService;
import com.gogirl.domain.store.oa.OverTimeRecord;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.shared.store.OrderTimeRecordPageQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "美甲师加班记录接口")
@AllArgsConstructor
@RestController
public class OverTimeRecordController {


    private final IOverTimeRecordService overTimeRecordService;

    @ApiOperation("加班记录")
    @PostMapping("/technician/overTimeRecord/queryPage")
    public JsonResult<IPage<OverTimeRecord>> queryPage(@RequestBody OrderTimeRecordPageQuery qry) {
        IPage<OverTimeRecord> page = overTimeRecordService.queryPage(qry);
        return JsonResult.success(page);
    }
}
