package com.gogirl.interfaces.order.serve;


import com.gogirl.application.order.serve.IAfterSaleBuyCardReasonService;
import com.gogirl.domain.order.serve.AfterSaleBuyCardReason;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-18
 */
@Api(tags = "不开卡理由接口")
@RestController
public class AfterSaleBuyCardReasonController {

    @Resource
    IAfterSaleBuyCardReasonService afterSaleBuyCardReasonService;

    @ApiOperation("不开卡的理由")
    @GetMapping("/technician/afterSaleBuyCardReason/list")
    public JsonResult<List<AfterSaleBuyCardReason>> list() {
        return JsonResult.success(afterSaleBuyCardReasonService.list());
    }

}
