package com.gogirl.infrastructure.common.interceptor;

import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.store.store.StoreManage;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.exception.ErrorCode;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.store.StoreManageMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.List;

@Component
@AllArgsConstructor
@Slf4j
public class LoginHandlerInterceptor implements HandlerInterceptor {

    private final GogirlTokenService gogirlTokenService;
    private final StoreManageMapper storeManageMapper;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {

        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod) handler;
        Method method = handlerMethod.getMethod();

        if (method.isAnnotationPresent(LoginIgnore.class)) {
            return true;
        }

        String token = request.getHeader("token");

        if (request.getRequestURI().contains("no_")) {
            return true;
        }

        String sourceFrom = request.getHeader("sourceFrom");
        if (sourceFrom == null) {
            return true;
        }

        if (sourceFrom.equals("customer")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(ErrorCode.CS_2000);
            }
        }

        if (sourceFrom.equals("technician")) {
            GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
            if (gogirlToken == null) {
                throw new RRException(ErrorCode.CS_2000);
            } else {
                if (gogirlToken.getDepartmentId() == null || gogirlToken.getDepartmentId() == 0) {
                    List<StoreManage> storeManageList = storeManageMapper.getTechnicianShopList(gogirlToken.getTechnicianId());
                    if (ListUtil.isNotEmpty(storeManageList) && storeManageList.size() == 1) {
                        StoreManage storeManage = storeManageList.get(0);
                        gogirlToken.setDepartmentId(storeManage.getId());
                        gogirlToken.setDepartmentName(storeManage.getName());
                        gogirlTokenService.updateByToken(gogirlToken);
                    } else {
                        throw new RRException(ErrorCode.ST_2005);
                    }
                }
            }
        }
        return true;
    }
}
